<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5 - Licence Number DGT-SERIAL
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

require_once(DIR . '/includes/class_bbcode.php');

/**
* Stack based BB code parser.
*
* @package 		vBulletin
* @version		$Revision: 25504 $
* @date 		$Date: 2008-01-21 06:42:40 -0600 (Mon, 21 Jan 2008) $
*
*/
class vB_VisitorMessageParser extends vB_BbCodeParser
{
	/**
	*
	*
	* @var	array
	*/
	var $tag_allowed = array(
		'basic',
		'color',
		'link',
		'align',
		'quote',
	);

	/**
	* Groupings for tags
	*
	* @var	array
	*/
	var $tag_groups = array();

	/**
	* Errors found in the signature
	*
	* @var	array
	*/
	var $errors = array();

	/**
	* Constructor. Sets up the tag permissions list.
	*
	* @param	vB_Registry	Reference to registry object
	* @param	array		The tag_list array for the parent class parser
	* @param	boolean		Whether to append custom tags (they will not be parsed anyway)
	*/
	function vB_VisitorMessageParser(&$registry, $tag_list, $append_custom_tags = true)
	{
		parent::vB_BbCodeParser($registry, $tag_list, false);

		$this->tag_groups = array(
			'b'      => 'basic',
			'i'      => 'basic',
			'u'      => 'basic',

			'color'  => 'color',
			'size'   => 'size',
			'font'   => 'font',

			'left'   => 'align',
			'center' => 'align',
			'right'  => 'align',
			'indent' => 'align',

			'list'   => 'list',

			'url'    => 'link',
			'email'  => 'link',
			'thread' => 'link',
			'post'   => 'link',

			'code'   => 'code',
			'php'    => 'php',
			'html'   => 'html',
			'quote'  => 'quote',
		);

		// General, allowed or not
		foreach ($this->tag_groups AS $tag => $tag_group)
		{
			if (isset($this->tag_list['no_option']["$tag"]))
			{
				$this->tag_list['no_option']["$tag"]['callback'] = 'check_bbcode_general';
				unset($this->tag_list['no_option']["$tag"]['html']);
			}

			if (isset($this->tag_list['option']["$tag"]))
			{
				$this->tag_list['option']["$tag"]['callback'] = 'check_bbcode_general';
				unset($this->tag_list['option']["$tag"]['html']);
			}
		}

		if ($append_custom_tags)
		{
			$this->append_custom_tags();
		}
	}

	/**
	* BB code callback allowed check
	*
	*/
	function check_bbcode_general($text)
	{
		$tag = $this->current_tag['name'];

		if ($this->tag_groups["$tag"] AND !in_array($this->tag_groups["$tag"], $this->tag_allowed))
		{
			$this->errors["$tag"] = 'tag_not_allowed';
		}

		return $text;
	}
	
	/**
	* Forces an error to be thrown when a custom tag is encountered
	*
	* @param String $text
	*/
	function error_on_custom_bbcode($text)
	{
		$tag = $this->current_tag['name'];
		$this->errors["$tag"] = 'tag_not_allowed';
	}
	
	/**
	* Overrides standard version in order to place the error-generating callback on all custom tags
	*/
	function append_custom_tags()
	{
		if (!$this->custom_fetched)
		{
			$this->custom_fetched = true;
			
			if ($this->registry->bbcodecache !== null) // get bbcodes from the datastore
			{
				foreach($this->registry->bbcodecache AS $customtag)
				{
					$this->tag_list[($customtag['twoparams'] ? 'option' : 'no_option')][strtolower($customtag['bbcodetag'])] = array('callback' => 'error_on_custom_bbcode');
				}
			}
			else // query bbcodes out of the database
			{
				$this->registry->bbcodecache = array();
	
				$bbcodes = $this->registry->db->query_read_slave("SELECT * FROM " . TABLE_PREFIX . "bbcode");
				while ($customtag = $this->registry->db->fetch_array($bbcodes))
				{
					$this->tag_list[($customtag['twoparams'] ? 'option' : 'no_option')]["$customtag[bbcodetag]"] = array('callback' => 'error_on_custom_bbcode');
					$this->registry->bbcodecache["$customtag[bbcodeid]"] = $customtag;
				}
			}
		}
		
		return;
	}
	
} // End Class

/*======================================================================*\
|| ####################################################################
|| # Downloaded: DGT-DATE
|| # CVS: $RCSfile$ - $Revision: 25504 $
|| ####################################################################
\*======================================================================*/

?>
